import {
  Card,
  CardContent,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import type { LucideIcon } from "lucide-react";
import { cn } from "@/lib/utils";

interface StatsCardProps {
  title: string;
  value: string;
  icon: LucideIcon;
  change: string;
  changeType?: "increase" | "decrease";
}

export function StatsCard({
  title,
  value,
  icon: Icon,
  change,
  changeType = "increase",
}: StatsCardProps) {
  return (
    <Card>
      <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
        <CardTitle className="text-sm font-medium">{title}</CardTitle>
        <Icon className="h-4 w-4 text-muted-foreground" />
      </CardHeader>
      <CardContent>
        <div className="text-2xl font-bold font-headline">{value}</div>
        <p
          className={cn(
            "text-xs text-muted-foreground",
            changeType === "increase" ? "text-emerald-500" : "text-red-500"
          )}
        >
          {change}
        </p>
      </CardContent>
    </Card>
  );
}
