
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Textarea } from "@/components/ui/textarea";
import { CreditCard, Shield } from "lucide-react";
import { Separator } from "@/components/ui/separator";

export default function SettingsPage() {
  return (
    <AppLayout>
        <h1 className="text-3xl font-bold font-headline tracking-tight">
            Configurações da Conta
        </h1>
        <p className="text-muted-foreground mb-8 mt-1">
            Gerencie suas informações de perfil, pagamentos e segurança.
        </p>

        <div className="space-y-8 max-w-2xl">
        <Card>
            <CardHeader>
            <CardTitle>Perfil Público</CardTitle>
            <CardDescription>
                Estas informações serão exibidas em sua página de criador.
            </CardDescription>
            </CardHeader>
            <CardContent className="space-y-6">
                <div className="flex items-center gap-4">
                <Avatar className="h-16 w-16">
                    <AvatarImage src="https://placehold.co/100x100.png" alt="Creator Name" />
                    <AvatarFallback>CN</AvatarFallback>
                </Avatar>
                <Button variant="outline">Alterar Foto</Button>
            </div>
            <div className="grid gap-2">
                <Label htmlFor="fullName">Nome Completo</Label>
                <Input id="fullName" defaultValue="InvestCorp" />
            </div>
            <div className="grid gap-2">
                <Label htmlFor="bio">Bio</Label>
                <Textarea id="bio" defaultValue="Pioneiros em IA para o mercado financeiro, criando bots que simplificam análises complexas e auxiliam em decisões de investimento." />
            </div>
            <Button>Salvar Perfil</Button>
            </CardContent>
        </Card>

        <Card>
            <CardHeader>
            <CardTitle className="flex items-center gap-2"><CreditCard className="h-5 w-5"/> Pagamentos</CardTitle>
            <CardDescription>
                Conecte sua conta Stripe para receber pagamentos por suas vendas.
            </CardDescription>
            </CardHeader>
            <CardContent className="space-y-4">
                <div className="flex items-center justify-between rounded-lg border p-4">
                    <div>
                        <p className="font-semibold">Stripe Connect</p>
                        <p className="text-sm text-muted-foreground">Conta conectada: acct_...****</p>
                    </div>
                    <Button variant="destructive">Desconectar</Button>
                </div>
            </CardContent>
        </Card>

            <Card>
            <CardHeader>
            <CardTitle className="flex items-center gap-2"><Shield className="h-5 w-5"/> Segurança</CardTitle>
            <CardDescription>
                Gerencie seu e-mail e senha.
            </CardDescription>
            </CardHeader>
            <CardContent className="space-y-4">
            <div className="grid gap-2">
                <Label htmlFor="email">Email</Label>
                <Input id="email" type="email" defaultValue="creator@investcorp.com" disabled />
            </div>
            <Separator />
                <div className="grid gap-2">
                <Label htmlFor="current-password">Senha Atual</Label>
                <Input id="current-password" type="password" />
                </div>
                <div className="grid gap-2">
                <Label htmlFor="new-password">Nova Senha</Label>
                <Input id="new-password" type="password" />
                </div>
                <Button>Alterar Senha</Button>
            </CardContent>
        </Card>
        </div>
    </AppLayout>
  );
}
