
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table";
import { Button } from "@/components/ui/button";
import { FileDown } from "lucide-react";

const sales = [
  {
    id: "1",
    agentName: "FinancePro Bot",
    buyerName: "John Doe",
    buyerEmail: "john.d@example.com",
    date: "2024-07-20",
    price: 49.99,
    commission: 39.99,
  },
  {
    id: "2",
    agentName: "Marketing Guru",
    buyerName: "Jane Smith",
    buyerEmail: "jane.s@example.com",
    date: "2024-07-19",
    price: 79.0,
    commission: 63.20,
  },
   {
    id: "3",
    agentName: "FinancePro Bot",
    buyerName: "Peter Jones",
    buyerEmail: "peter.j@example.com",
    date: "2024-07-18",
    price: 49.99,
    commission: 39.99,
  },
];

export default function SalesPage() {
  return (
    <AppLayout>
        <div className="flex items-center justify-between gap-4 mb-8">
            <div>
                <h1 className="text-3xl font-bold font-headline tracking-tight">
                    Vendas
                </h1>
                <p className="text-muted-foreground mt-1">
                    Acompanhe seu histórico de vendas e receita.
                </p>
            </div>
            <Button>
                <FileDown className="mr-2 h-4 w-4" />
                Exportar CSV
            </Button>
        </div>
        <Card>
        <CardHeader>
            <CardTitle>Histórico de Vendas</CardTitle>
            <CardDescription>
            Aqui está a lista de todas as suas vendas.
            </CardDescription>
        </CardHeader>
        <CardContent>
            <Table>
            <TableHeader>
                <TableRow>
                <TableHead>Agente</TableHead>
                <TableHead>Comprador</TableHead>
                <TableHead>Data</TableHead>
                <TableHead className="text-right">Valor Total</TableHead>
                <TableHead className="text-right">Sua Comissão</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {sales.map((sale) => (
                <TableRow key={sale.id}>
                    <TableCell className="font-medium">{sale.agentName}</TableCell>
                    <TableCell>
                    <div className="font-medium">{sale.buyerName}</div>
                    <div className="text-sm text-muted-foreground">{sale.buyerEmail}</div>
                    </TableCell>
                    <TableCell>{sale.date}</TableCell>
                    <TableCell className="text-right">
                    ${sale.price.toFixed(2)}
                    </TableCell>
                    <TableCell className="text-right font-semibold text-primary">
                    ${sale.commission.toFixed(2)}
                    </TableCell>
                </TableRow>
                ))}
            </TableBody>
            </Table>
        </CardContent>
        </Card>
    </AppLayout>
  );
}
