
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table";
import { Button } from "@/components/ui/button";
import { FileDown, DollarSign, Eye, Users, Bot } from "lucide-react";
import { StatsCard } from "@/components/dashboard/StatsCard";
import { SalesChart } from "@/app/pt/dashboard/SalesChart";

const sales = [
  {
    id: "1",
    agentName: "FinancePro Bot",
    buyerName: "John Doe",
    buyerEmail: "john.d@example.com",
    date: "2024-07-20",
    price: 49.99,
    commission: 39.99,
  },
  {
    id: "2",
    agentName: "Marketing Guru",
    buyerName: "Jane Smith",
    buyerEmail: "jane.s@example.com",
    date: "2024-07-19",
    price: 79.0,
    commission: 63.20,
  },
   {
    id: "3",
    agentName: "FinancePro Bot",
    buyerName: "Peter Jones",
    buyerEmail: "peter.j@example.com",
    date: "2024-07-18",
    price: 49.99,
    commission: 39.99,
  },
];

export default function SalesPage() {
    const translations = {
        dashboard: "Dashboard",
        myAgents: "Meus Agentes",
        sales: "Vendas",
        purchases: "Compras",
        myAccount: "Minha Conta",
        support: "Suporte",
        marketplace: "Marketplace",
        createAgent: "Criar Agente",
        settings: "Configurações",
        logout: "Sair",
        affiliates: "Afiliados",
      };
  return (
    <AppLayout translations={translations}>
        <div className="flex items-center justify-between gap-4 mb-8">
            <div>
                <h1 className="text-3xl font-bold font-headline tracking-tight">
                    Vendas
                </h1>
                <p className="text-muted-foreground mt-1">
                    Acompanhe seu histórico de vendas e receita.
                </p>
            </div>
            <Button>
                <FileDown className="mr-2 h-4 w-4" />
                Exportar CSV
            </Button>
        </div>

        <div className="grid gap-6 md:grid-cols-2 lg:grid-cols-4 mb-8">
          <StatsCard
            title="Vendas Totais"
            value="R$12.450"
            icon={DollarSign}
            change="+12.5% do último mês"
          />
          <StatsCard
            title="Visualizações de Agentes"
            value="245.830"
            icon={Eye}
            change="+8.2% do último mês"
          />
          <StatsCard
            title="Clientes Ativos"
            value="1.284"
            icon={Users}
            change="-1.5% do último mês"
            changeType="decrease"
          />
          <StatsCard
            title="Agentes Ativos"
            value="12"
            icon={Bot}
            change="+2 do último mês"
          />
        </div>

        <div className="mb-8">
            <SalesChart />
        </div>

        <Card>
        <CardHeader>
            <CardTitle>Histórico de Vendas</CardTitle>
            <CardDescription>
            Aqui está a lista de todas as suas vendas.
            </CardDescription>
        </CardHeader>
        <CardContent>
            <Table>
            <TableHeader>
                <TableRow>
                <TableHead>Agente</TableHead>
                <TableHead>Comprador</TableHead>
                <TableHead>Data</TableHead>
                <TableHead className="text-right">Valor Total</TableHead>
                <TableHead className="text-right">Sua Comissão</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {sales.map((sale) => (
                <TableRow key={sale.id}>
                    <TableCell className="font-medium">{sale.agentName}</TableCell>
                    <TableCell>
                    <div className="font-medium">{sale.buyerName}</div>
                    <div className="text-sm text-muted-foreground">{sale.buyerEmail}</div>
                    </TableCell>
                    <TableCell>{sale.date}</TableCell>
                    <TableCell className="text-right">
                    R${sale.price.toFixed(2)}
                    </TableCell>
                    <TableCell className="text-right font-semibold text-primary">
                    R${sale.commission.toFixed(2)}
                    </TableCell>
                </TableRow>
                ))}
            </TableBody>
            </Table>
        </CardContent>
        </Card>
    </AppLayout>
  );
}
