"use client";

import { Header } from "@/components/layout/Header";
import { Footer } from "@/components/layout/Footer";
import { Button } from "@/components/ui/button";
import { ArrowRight } from "lucide-react";
import Link from "next/link";
import Image from "next/image";
import { AgentTypeSelectionDialog } from "@/components/agent/AgentTypeSelectionDialog";

export default function Home() {
  return (
    <>
      <Header />
      <main className="flex-grow">
        <section className="text-center py-20 lg:py-32 px-4 bg-card/50">
          <div className="max-w-4xl mx-auto">
            <h1 className="text-4xl md:text-6xl font-bold font-headline tracking-tight bg-gradient-to-r from-primary via-accent to-primary text-transparent bg-clip-text mb-4">
              Crie e venda seu agente de IA
            </h1>
            <p className="text-lg md:text-xl text-muted-foreground max-w-2xl mx-auto mb-8">
              A plataforma definitiva para criar, vender e integrar agentes de
              IA em qualquer canal. Gere links únicos, receba por venda e
              conecte com WhatsApp e mais.
            </p>
            <div className="flex gap-4 justify-center">
              <AgentTypeSelectionDialog
                locale="pt"
                trigger={
                  <Button size="lg" className="font-bold">
                    Criar Agente Agora <ArrowRight className="ml-2 h-5 w-5" />
                  </Button>
                }
              />
              <Button size="lg" variant="outline" className="font-bold" asChild>
                <Link href="/pt/marketplace">Explorar Marketplace</Link>
              </Button>
            </div>
          </div>
        </section>

        <section className="py-16 px-4 md:px-8">
          <div className="max-w-5xl mx-auto text-center mb-12">
            <h2 className="text-3xl font-bold font-headline mb-4">
              Como funciona?
            </h2>
            <p className="text-muted-foreground">
              Em três passos simples, você transforma sua ideia em um negócio de
              IA.
            </p>
          </div>
          <div className="max-w-7xl mx-auto grid md:grid-cols-3 gap-8 text-center">
            <div className="p-6 border rounded-lg bg-card/50">
              <h3 className="text-2xl font-bold font-headline mb-2">1. Crie</h3>
              <p className="text-muted-foreground">
                Defina a persona, adicione sua base de conhecimento e configure
                as instruções do seu agente.
              </p>
            </div>
            <div className="p-6 border rounded-lg bg-card/50">
              <h3 className="text-2xl font-bold font-headline mb-2">
                2. Venda
              </h3>
              <p className="text-muted-foreground">
                Defina o preço, publique no marketplace e gere links de
                pagamento únicos para seus clientes.
              </p>
            </div>
            <div className="p-6 border rounded-lg bg-card/50">
              <h3 className="text-2xl font-bold font-headline mb-2">
                3. Integre
              </h3>
              <p className="text-muted-foreground">
                Conecte seu agente ao WhatsApp, Instagram, Telegram ou qualquer
                site com poucos cliques.
              </p>
            </div>
          </div>
        </section>

        <section className="py-16 px-4 md:px-8 bg-card/50">
          <div className="max-w-5xl mx-auto text-center">
            <h2 className="text-3xl font-bold font-headline mb-4">
              Pronto para começar?
            </h2>
            <p className="text-muted-foreground mb-8">
              Junte-se à revolução dos agentes de IA e comece a monetizar seu
              conhecimento hoje mesmo.
            </p>
            <Button size="lg" asChild>
              <Link href="/pt/signup">Criar Conta Gratuita</Link>
            </Button>
          </div>
        </section>
      </main>
      <Footer />
    </>
  );
}
