
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import { Button } from "@/components/ui/button";
import { PlusCircle } from "lucide-react";
import { AgentCard } from "@/components/agent/AgentCard";
import { agents } from "@/lib/mock-data";
import { AgentTypeSelectionDialog } from "@/components/agent/AgentTypeSelectionDialog";

export default function MyAgentsPage() {
    const createdAgents = agents.slice(0, 2);
    const purchasedAgents = agents.slice(2, 4);
    const draftAgent = {
        ...agents[0],
        id: 'draft-1',
        name: "Agente em Rascunho",
        description: "Este agente ainda está em desenvolvimento...",
    }

    const translations = {
        dashboard: "Dashboard",
        myAgents: "Meus Agentes",
        sales: "Vendas",
        purchases: "Compras",
        myAccount: "Minha Conta",
        support: "Suporte",
        marketplace: "Marketplace",
        createAgent: "Criar Agente",
        settings: "Configurações",
        logout: "Sair",
      };
    return (
        <AppLayout translations={translations}>
            <div className="flex items-center justify-between mb-8">
                <div>
                    <h1 className="text-3xl font-bold font-headline">Meus Agentes</h1>
                    <p className="text-muted-foreground">Gerencie, edite ou crie novos agentes.</p>
                </div>
                 <AgentTypeSelectionDialog 
                    trigger={
                        <Button>
                            <PlusCircle className="mr-2"/>
                            Criar Novo Agente
                        </Button>
                    }
                    locale="pt"
                />
            </div>

            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                <AgentCard agent={draftAgent} variant="draft"/>
                {createdAgents.map((agent) => (
                    <AgentCard key={`created-${agent.id}`} agent={agent} variant="created"/>
                ))}
                {purchasedAgents.map((agent) => (
                    <AgentCard key={`purchased-${agent.id}`} agent={agent} variant="purchased"/>
                ))}
            </div>
             
        </AppLayout>
    )
}
