
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table";
import { Button } from "@/components/ui/button";
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar";
import { Check, X } from "lucide-react";
import { useToast } from "@/hooks/use-toast";

const affiliateRequests = [
  {
    id: "1",
    userName: "Marketing Pro",
    userImage: "https://placehold.co/40x40.png",
    agentName: "FinancePro Bot",
    date: "2024-07-22",
  },
  {
    id: "2",
    userName: "Sales Master",
    userImage: "https://placehold.co/40x40.png",
    agentName: "Marketing Guru",
    date: "2024-07-21",
  },
   {
    id: "3",
    userName: "Content Creator",
    userImage: "https://placehold.co/40x40.png",
    agentName: "FinancePro Bot",
    date: "2024-07-20",
  },
];

export default function AffiliatesPage() {
    const { toast } = useToast();
    const translations = {
        dashboard: "Dashboard",
        myAgents: "Meus Agentes",
        sales: "Vendas",
        purchases: "Compras",
        myAccount: "Minha Conta",
        support: "Suporte",
        marketplace: "Marketplace",
        createAgent: "Criar Agente",
        settings: "Configurações",
        logout: "Sair",
        affiliates: "Afiliados",
    };
  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline tracking-tight mb-2">
            Aprovações de Afiliados
        </h1>
        <p className="text-muted-foreground mb-8">
            Gerencie as solicitações de afiliação para seus agentes.
        </p>
        <Card>
        <CardHeader>
            <CardTitle>Solicitações Pendentes</CardTitle>
            <CardDescription>
            Aprove ou rejeite as solicitações para promover seus agentes.
            </CardDescription>
        </CardHeader>
        <CardContent>
            <Table>
            <TableHeader>
                <TableRow>
                <TableHead>Solicitante</TableHead>
                <TableHead>Agente</TableHead>
                <TableHead>Data da Solicitação</TableHead>
                <TableHead className="text-right">Ações</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {affiliateRequests.map((request) => (
                <TableRow key={request.id}>
                    <TableCell className="font-medium">
                        <div className="flex items-center gap-3">
                            <Avatar className="h-9 w-9">
                                <AvatarImage src={request.userImage} alt={request.userName} />
                                <AvatarFallback>{request.userName.charAt(0)}</AvatarFallback>
                            </Avatar>
                            <span>{request.userName}</span>
                        </div>
                    </TableCell>
                    <TableCell>{request.agentName}</TableCell>
                    <TableCell>{request.date}</TableCell>
                    <TableCell className="text-right">
                        <div className="flex gap-2 justify-end">
                             <Button variant="outline" size="icon" className="border-red-500 text-red-500 hover:bg-red-500/10 hover:text-red-600" onClick={() => toast({title: "Solicitação Rejeitada"})}>
                                <X className="h-4 w-4" />
                            </Button>
                            <Button variant="outline" size="icon" className="border-green-500 text-green-500 hover:bg-green-500/10 hover:text-green-600" onClick={() => toast({title: "Solicitação Aprovada"})}>
                                <Check className="h-4 w-4" />
                            </Button>
                        </div>
                    </TableCell>
                </TableRow>
                ))}
            </TableBody>
            </Table>
        </CardContent>
        </Card>
    </AppLayout>
  );
}
