import { Header } from "@/components/layout/Header";
import { Footer } from "@/components/layout/Footer";
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Textarea } from "@/components/ui/textarea";
import { User, Edit } from "lucide-react";
import { AgentCard } from "@/components/agent/AgentCard";
import { agents } from "@/lib/mock-data";


export default function ProfilePage() {
  const userAgents = agents.slice(0, 2);

  return (
    <>
      <Header />
      <main className="flex-grow container py-12 px-4 md:px-8">
        <div className="max-w-5xl mx-auto">
          <div className="flex items-center gap-4 mb-4">
            <div className="p-3 bg-primary/10 rounded-lg">
                <User className="h-8 w-8 text-primary" />
            </div>
            <h1 className="text-4xl font-bold font-headline tracking-tight">
              Perfil do Criador
            </h1>
          </div>
          <p className="text-muted-foreground mb-8">
            Gerencie suas informações públicas e veja seus agentes.
          </p>

          <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <div className="lg:col-span-1 space-y-8">
              <Card>
                <CardHeader className="items-center text-center">
                    <Avatar className="h-24 w-24 mb-4">
                        <AvatarImage src="https://placehold.co/100x100.png" alt="Creator Name" />
                        <AvatarFallback>CN</AvatarFallback>
                    </Avatar>
                    <CardTitle className="font-headline text-2xl">InvestCorp</CardTitle>
                    <CardDescription>Pioneiros em IA para o mercado financeiro.</CardDescription>
                </CardHeader>
                 <CardContent>
                    <Button className="w-full">
                        <Edit className="mr-2 h-4 w-4"/>
                        Editar Perfil Público
                    </Button>
                </CardContent>
              </Card>
               <Card>
                <CardHeader>
                  <CardTitle>Gerenciar Conta</CardTitle>
                </CardHeader>
                <CardContent className="space-y-4">
                  <div className="grid gap-2">
                    <Label htmlFor="email">Email</Label>
                    <Input id="email" type="email" defaultValue="creator@investcorp.com" disabled />
                  </div>
                   <div className="grid gap-2">
                    <Label htmlFor="bio">Bio</Label>
                    <Textarea id="bio" defaultValue="Pioneiros em IA para o mercado financeiro, criando bots que simplificam análises complexas e auxiliam em decisões de investimento." />
                  </div>
                   <Button className="w-full" variant="outline">Salvar Alterações</Button>
                </CardContent>
              </Card>
            </div>
            <div className="lg:col-span-2">
                <Card>
                    <CardHeader>
                        <CardTitle className="font-headline text-2xl">Meus Agentes à Venda</CardTitle>
                        <CardDescription>Agentes que você criou e estão disponíveis no marketplace.</CardDescription>
                    </CardHeader>
                    <CardContent className="grid sm:grid-cols-2 gap-6">
                        {userAgents.map((agent) => (
                            <AgentCard key={agent.id} agent={agent} variant="marketplace" />
                        ))}
                    </CardContent>
                </Card>
            </div>
          </div>
        </div>
      </main>
      <Footer />
    </>
  );
}
