
"use client";

import { Header } from "@/components/layout/Header";
import { Footer } from "@/components/layout/Footer";
import { Button } from "@/components/ui/button";
import { ArrowRight } from "lucide-react";
import Link from "next/link";
import Image from "next/image";
import { AgentTypeSelectionDialog } from "@/components/agent/AgentTypeSelectionDialog";

export default function Home() {
  return (
    <>
      <Header />
      <main className="flex-grow">
        <section className="text-center py-20 lg:py-32 px-4 bg-card/50">
          <div className="max-w-4xl mx-auto">
            <h1 className="text-4xl md:text-6xl font-bold font-headline tracking-tight bg-gradient-to-r from-primary via-accent to-primary text-transparent bg-clip-text mb-4">
              Crea y vende tu agente de IA
            </h1>
            <p className="text-lg md:text-xl text-muted-foreground max-w-2xl mx-auto mb-8">
              La plataforma definitiva para crear, vender e integrar agentes de IA en cualquier canal. Genera enlaces únicos, recibe pagos por venta y conéctate con WhatsApp y más.
            </p>
            <div className="flex gap-4 justify-center">
              <AgentTypeSelectionDialog
                locale="es"
                trigger={
                  <Button size="lg" className="font-bold">
                    Crear Agente Ahora <ArrowRight className="ml-2 h-5 w-5" />
                  </Button>
                }
              />
              <Button size="lg" variant="outline" className="font-bold" asChild>
                 <Link href="/es/marketplace">Explorar Marketplace</Link>
              </Button>
            </div>
          </div>
        </section>

        <section className="py-16 px-4 md:px-8">
            <div className="max-w-5xl mx-auto text-center mb-12">
                <h2 className="text-3xl font-bold font-headline mb-4">¿Cómo funciona?</h2>
                <p className="text-muted-foreground">En tres sencillos pasos, conviertes tu idea en un negocio de IA.</p>
            </div>
            <div className="max-w-7xl mx-auto grid md:grid-cols-3 gap-8 text-center">
                <div className="p-6 border rounded-lg bg-card/50">
                    <h3 className="text-2xl font-bold font-headline mb-2">1. Crea</h3>
                    <p className="text-muted-foreground">Define la persona, añade tu base de conocimientos y configura las instrucciones de tu agente.</p>
                </div>
                <div className="p-6 border rounded-lg bg-card/50">
                    <h3 className="text-2xl font-bold font-headline mb-2">2. Vende</h3>
                    <p className="text-muted-foreground">Define el precio, publícalo en el marketplace y genera enlaces de pago únicos para tus clientes.</p>
                </div>
                <div className="p-6 border rounded-lg bg-card/50">
                    <h3 className="text-2xl font-bold font-headline mb-2">3. Integra</h3>
                    <p className="text-muted-foreground">Conecta tu agente a WhatsApp, Instagram, Telegram o cualquier sitio web con unos pocos clics.</p>
                </div>
            </div>
        </section>

        <section className="py-16 px-4 md:px-8 bg-card/50">
            <div className="max-w-5xl mx-auto text-center">
                <h2 className="text-3xl font-bold font-headline mb-4">¿Listo para empezar?</h2>
                <p className="text-muted-foreground mb-8">Únete a la revolución de los agentes de IA y empieza a monetizar tu conocimiento hoy mismo.</p>
                <Button size="lg" asChild>
                    <Link href="/es/signup">Crear Cuenta Gratis</Link>
                </Button>
            </div>
        </section>

      </main>
      <Footer />
    </>
  );
}
