
"use client";

import Image from "next/image";
import { AppLayout } from "@/components/layout/AppLayout";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Settings } from "lucide-react";

const integrations = [
    {
        name: "WhatsApp",
        description: "Conecta tus agentes a WhatsApp Business para automatización de chats.",
        logo: "/whatsapp-logo.svg",
        connected: true,
    },
    {
        name: "Instagram",
        description: "Integra con Instagram Messenger para interactuar con tus seguidores.",
        logo: "/instagram-logo.svg",
        connected: false,
    },
    {
        name: "Telegram",
        description: "Usa la API de Bots de Telegram para crear agentes interactivos.",
        logo: "/telegram-logo.svg",
        connected: false,
    },
     {
        name: "Website",
        description: "Incrusta tu agente en cualquier sitio web con un simple fragmento de código.",
        logo: "/website-logo.svg",
        connected: true,
    },
];

export default function IntegrationsPage() {
    const translations = {
        dashboard: "Dashboard",
        myAgents: "Mis Agentes",
        sales: "Ventas",
        purchases: "Compras",
        integrations: "Integraciones",
        support: "Soporte",
        marketplace: "Marketplace",
        createAgent: "Crear Agente",
        settings: "Configuración",
        logout: "Cerrar Sesión",
    };
  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline tracking-tight">
            Integraciones de Canal
        </h1>
        <p className="text-muted-foreground mb-8 mt-1">
            Conecta tus agentes a diferentes canales para llegar a tus clientes dondequiera que estén.
        </p>

        <div className="grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
        {integrations.map((integration) => (
            <Card key={integration.name}>
                <CardHeader>
                    <div className="flex items-start justify-between gap-4">
                        <div className="flex items-center gap-4">
                            <Image src={integration.logo} alt={`${integration.name} logo`} width={40} height={40} />
                            <div>
                                <CardTitle className="font-headline text-xl">{integration.name}</CardTitle>
                                <CardDescription className="mt-1">{integration.connected ? "Conectado" : "No conectado"}</CardDescription>
                            </div>
                        </div>
                    </div>
                </CardHeader>
                <CardContent>
                    <p className="text-sm text-muted-foreground mb-4">{integration.description}</p>
                     <Button variant={integration.connected ? "secondary" : "default"} className="w-full">
                        {integration.connected ? <Settings className="mr-2 h-4 w-4"/> : null}
                        {integration.connected ? "Gestionar" : "Conectar"}
                    </Button>
                </CardContent>
            </Card>
        ))}
        </div>
    </AppLayout>
  );
}
