
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from "@/components/ui/accordion";
import { MessageSquare, BookOpen } from "lucide-react";
import { Label } from "@/components/ui/label";
import { Input } from "@/components/ui/input";
import { Textarea } from "@/components/ui/textarea";
import { Button } from "@/components/ui/button";

export default function SupportPage() {
  const faqs = [
    {
      question: "How do I create my first agent?",
      answer: "Go to the 'Create Agent' page, fill in the persona, knowledge, and instructions. Then, set a price and publish it to the marketplace.",
    },
    {
      question: "How does the payment split work?",
      answer: "When you connect your Stripe account, payments are split automatically. The platform retains a commission, and the rest is sent to your account.",
    },
    {
      question: "Can I sell an agent outside the marketplace?",
      answer: "Yes! When creating an agent, you can choose to keep it 'Unlisted' and share the sales link directly with your clients.",
    },
     {
      question: "How do I integrate my agent with WhatsApp?",
      answer: "On the 'Integrations' page, select WhatsApp, follow the instructions to connect your WhatsApp Business API account (via one of our partners), and link the desired agent.",
    },
  ];
  const translations = {
    dashboard: "Dashboard",
    myAgents: "My Agents",
    sales: "Sales",
    purchases: "Purchases",
    integrations: "Integrations",
    support: "Support",
    marketplace: "Marketplace",
    createAgent: "Create Agent",
    settings: "Settings",
    logout: "Logout",
  };

  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline tracking-tight">
            Support & Help
        </h1>
        <p className="text-muted-foreground mb-8 mt-1">
            Need help? Find answers here or contact us.
        </p>

        <div className="grid md:grid-cols-2 gap-8">
        <div className="space-y-8">
            <Card>
                <CardHeader>
                    <CardTitle className="flex items-center gap-2"><BookOpen className="h-5 w-5"/> Frequently Asked Questions (FAQ)</CardTitle>
                </CardHeader>
                <CardContent>
                    <Accordion type="single" collapsible className="w-full">
                        {faqs.map((faq, index) => (
                            <AccordionItem key={index} value={`item-${index}`}>
                                <AccordionTrigger>{faq.question}</AccordionTrigger>
                                <AccordionContent>{faq.answer}</AccordionContent>
                            </AccordionItem>
                        ))}
                    </Accordion>
                </CardContent>
            </Card>
        </div>
            <div className="space-y-8">
            <Card>
                <CardHeader>
                    <CardTitle className="flex items-center gap-2"><MessageSquare className="h-5 w-5"/> Contact Us</CardTitle>
                    <CardDescription>If you didn't find your answer, send us a message.</CardDescription>
                </CardHeader>
                <CardContent>
                    <form className="space-y-4">
                        <div className="grid w-full items-center gap-1.5">
                            <Label htmlFor="name">Your Name</Label>
                            <Input type="text" id="name" placeholder="Your full name" />
                        </div>
                        <div className="grid w-full items-center gap-1.5">
                            <Label htmlFor="email">Your Email</Label>
                            <Input type="email" id="email" placeholder="your@email.com" />
                        </div>
                        <div className="grid w-full items-center gap-1.5">
                            <Label htmlFor="message">Your Message</Label>
                            <Textarea placeholder="Describe your problem or question here..." id="message" />
                        </div>
                        <Button className="w-full">Send Message</Button>
                    </form>
                </CardContent>
            </Card>
        </div>
        </div>
    </AppLayout>
  );
}
