
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Textarea } from "@/components/ui/textarea";
import { CreditCard, Shield, LifeBuoy, Mail, Phone, Link as LinkIcon, Globe } from "lucide-react";
import { Separator } from "@/components/ui/separator";
import Link from "next/link";
import { usePathname } from "next/navigation";

export default function SettingsPage() {
    const pathname = usePathname();
    const locale = pathname.split('/')[1] || 'pt';

    const translations = {
        dashboard: "Dashboard",
        myAgents: "My Agents",
        sales: "Sales",
        purchases: "Purchases",
        myAccount: "My Account",
        support: "Support",
        marketplace: "Marketplace",
        createAgent: "Create Agent",
        settings: "Settings",
        logout: "Logout",
        affiliates: "Affiliates",
    };

    const SocialInput = ({ id, name, placeholder, icon: Icon }: { id: string, name: string, placeholder: string, icon: React.ElementType }) => (
         <div className="grid gap-2">
            <Label htmlFor={id}>{name}</Label>
            <div className="flex items-center gap-2">
                <Icon className="h-5 w-5 text-muted-foreground" />
                <Input id={id} placeholder={placeholder} />
            </div>
        </div>
    );

  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline tracking-tight">
            My Account
        </h1>
        <p className="text-muted-foreground mb-8 mt-1">
            Manage your profile, payment, and security information.
        </p>

        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <div className="lg:col-span-2 space-y-8">
                <Card>
                    <CardHeader>
                    <CardTitle>Public Profile</CardTitle>
                    <CardDescription>
                        This information will be displayed on your creator page.
                    </CardDescription>
                    </CardHeader>
                    <CardContent className="space-y-6">
                        <div className="flex items-center gap-4">
                        <Avatar className="h-16 w-16">
                            <AvatarImage src="https://placehold.co/100x100.png" alt="Creator Name" />
                            <AvatarFallback>CN</AvatarFallback>
                        </Avatar>
                        <Button variant="outline">Change Photo</Button>
                    </div>
                    <div className="grid gap-2">
                        <Label htmlFor="fullName">Display Name</Label>
                        <Input id="fullName" defaultValue="InvestCorp" />
                    </div>
                    <div className="grid gap-2">
                        <Label htmlFor="bio">Bio</Label>
                        <Textarea id="bio" defaultValue="Pioneers in AI for the financial market, creating bots that simplify complex analysis and assist in investment decisions." />
                    </div>
                     <div className="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <SocialInput id="public-email" name="Public Email" placeholder="contact@example.com" icon={Mail} />
                        <SocialInput id="phone" name="Phone" placeholder="+1 (555) 123-4567" icon={Phone} />
                        <SocialInput id="website" name="Website" placeholder="https://example.com" icon={Globe} />
                        <SocialInput id="twitter" name="Twitter" placeholder="https://twitter.com/username" icon={LinkIcon} />
                        <SocialInput id="linkedin" name="LinkedIn" placeholder="https://linkedin.com/in/username" icon={LinkIcon} />
                        <SocialInput id="github" name="GitHub" placeholder="https://github.com/username" icon={LinkIcon} />
                    </div>
                    <Button>Save Profile</Button>
                    </CardContent>
                </Card>

                 <Card>
                    <CardHeader>
                    <CardTitle className="flex items-center gap-2"><Shield className="h-5 w-5"/> Security</CardTitle>
                    <CardDescription>
                        Manage your email and password.
                    </CardDescription>
                    </CardHeader>
                    <CardContent className="space-y-4">
                    <div className="grid gap-2">
                        <Label htmlFor="email">Account Email</Label>
                        <Input id="email" type="email" defaultValue="creator@investcorp.com" disabled />
                    </div>
                    <Separator />
                        <div className="grid gap-2">
                        <Label htmlFor="current-password">Current Password</Label>
                        <Input id="current-password" type="password" />
                        </div>
                        <div className="grid gap-2">
                        <Label htmlFor="new-password">New Password</Label>
                        <Input id="new-password" type="password" />
                        </div>
                        <Button>Change Password</Button>
                    </CardContent>
                </Card>
            </div>
            <div className="lg:col-span-1 space-y-8">
                <Card>
                    <CardHeader>
                    <CardTitle className="flex items-center gap-2"><CreditCard className="h-5 w-5"/> Payments</CardTitle>
                    <CardDescription>
                        Connect your Stripe account to receive payments.
                    </CardDescription>
                    </CardHeader>
                    <CardContent className="space-y-4">
                        <div className="flex items-center justify-between rounded-lg border p-4">
                            <div>
                                <p className="font-semibold">Stripe Connect</p>
                                <p className="text-sm text-muted-foreground">Connected: acct_...****</p>
                            </div>
                            <Button variant="destructive">Disconnect</Button>
                        </div>
                    </CardContent>
                </Card>

                 <Card>
                    <CardHeader>
                        <CardTitle className="flex items-center gap-2"><LifeBuoy className="h-5 w-5"/> Support</CardTitle>
                        <CardDescription>
                            Need help? Visit our support page for FAQs and contact information.
                        </CardDescription>
                    </CardHeader>
                    <CardContent>
                        <Button asChild>
                            <Link href={`/${locale}/support`}>Go to Support Page</Link>
                        </Button>
                    </CardContent>
                </Card>
            </div>
        </div>
    </AppLayout>
  );
}

    