
"use client";

import { Header } from "@/components/layout/Header";
import { Footer } from "@/components/layout/Footer";
import { Button } from "@/components/ui/button";
import { ArrowRight } from "lucide-react";
import Link from "next/link";
import Image from "next/image";
import { AgentTypeSelectionDialog } from "@/components/agent/AgentTypeSelectionDialog";

export default function Home() {
  return (
    <>
      <Header />
      <main className="flex-grow">
        <section className="text-center py-20 lg:py-32 px-4 bg-card/50">
          <div className="max-w-4xl mx-auto">
            <h1 className="text-4xl md:text-6xl font-bold font-headline tracking-tight bg-gradient-to-r from-primary via-accent to-primary text-transparent bg-clip-text mb-4">
              Create and sell your AI agent
            </h1>
            <p className="text-lg md:text-xl text-muted-foreground max-w-2xl mx-auto mb-8">
              The definitive platform to create, sell, and integrate AI agents on any channel. Generate unique links, get paid per sale, and connect with WhatsApp and more.
            </p>
            <div className="flex gap-4 justify-center">
               <AgentTypeSelectionDialog
                locale="en"
                trigger={
                  <Button size="lg" className="font-bold">
                    Create Agent Now <ArrowRight className="ml-2 h-5 w-5" />
                  </Button>
                }
              />
              <Button size="lg" variant="outline" className="font-bold" asChild>
                 <Link href="/en/marketplace">Explore Marketplace</Link>
              </Button>
            </div>
          </div>
        </section>

        <section className="py-16 px-4 md:px-8">
            <div className="max-w-5xl mx-auto text-center mb-12">
                <h2 className="text-3xl font-bold font-headline mb-4">How does it work?</h2>
                <p className="text-muted-foreground">In three simple steps, you turn your idea into an AI business.</p>
            </div>
            <div className="max-w-7xl mx-auto grid md:grid-cols-3 gap-8 text-center">
                <div className="p-6 border rounded-lg bg-card/50">
                    <h3 className="text-2xl font-bold font-headline mb-2">1. Create</h3>
                    <p className="text-muted-foreground">Define the persona, add your knowledge base, and set up your agent's instructions.</p>
                </div>
                <div className="p-6 border rounded-lg bg-card/50">
                    <h3 className="text-2xl font-bold font-headline mb-2">2. Sell</h3>
                    <p className="text-muted-foreground">Set the price, publish on the marketplace, and generate unique payment links for your customers.</p>
                </div>
                <div className="p-6 border rounded-lg bg-card/50">
                    <h3 className="text-2xl font-bold font-headline mb-2">3. Integrate</h3>
                    <p className="text-muted-foreground">Connect your agent to WhatsApp, Instagram, Telegram, or any website with a few clicks.</p>
                </div>
            </div>
        </section>

        <section className="py-16 px-4 md:px-8 bg-card/50">
            <div className="max-w-5xl mx-auto text-center">
                <h2 className="text-3xl font-bold font-headline mb-4">Ready to start?</h2>
                <p className="text-muted-foreground mb-8">Join the AI agent revolution and start monetizing your knowledge today.</p>
                <Button size="lg" asChild>
                    <Link href="/en/signup">Create Free Account</Link>
                </Button>
            </div>
        </section>

      </main>
      <Footer />
    </>
  );
}
