"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatasetMetadataSchema = exports.DatasetTypeSchema = exports.DatasetSchemaSchema = exports.EvalRunSchema = exports.EvalKeyAugmentsSchema = exports.EvalRunKeySchema = exports.EvalResultSchema = exports.EvalMetricSchema = exports.EvalStatusEnum = exports.EvalInputDatasetSchema = exports.EvalInputSchema = exports.EvaluationDatasetSchema = exports.EvaluationSampleSchema = exports.DatasetSchema = exports.InferenceDatasetSchema = exports.InferenceSampleSchema = exports.GenerateInputJSONSchema = exports.GenerateRequestJSONSchema = exports.ModelInferenceInputJSONSchema = exports.ModelInferenceInputSchema = void 0;
const zod_1 = require("zod");
const zod_to_json_schema_1 = __importDefault(require("zod-to-json-schema"));
const model_1 = require("./model");
exports.ModelInferenceInputSchema = zod_1.z.union([
    zod_1.z.string(),
    model_1.GenerateRequestSchema,
]);
exports.ModelInferenceInputJSONSchema = (0, zod_to_json_schema_1.default)(exports.ModelInferenceInputSchema, {
    $refStrategy: 'none',
    removeAdditionalStrategy: 'strict',
});
exports.GenerateRequestJSONSchema = (0, zod_to_json_schema_1.default)(model_1.GenerateRequestSchema, {
    $refStrategy: 'none',
    removeAdditionalStrategy: 'strict',
});
exports.GenerateInputJSONSchema = (0, zod_to_json_schema_1.default)(zod_1.z.union([model_1.GenerateRequestSchema, model_1.GenerateActionOptionsSchema]), {
    $refStrategy: 'none',
    removeAdditionalStrategy: 'strict',
});
exports.InferenceSampleSchema = zod_1.z.object({
    testCaseId: zod_1.z.string().optional(),
    input: zod_1.z.any(),
    reference: zod_1.z.any().optional(),
});
exports.InferenceDatasetSchema = zod_1.z.array(exports.InferenceSampleSchema);
exports.DatasetSchema = zod_1.z.array(zod_1.z.object({
    testCaseId: zod_1.z.string(),
    input: zod_1.z.any(),
    reference: zod_1.z.any().optional(),
}));
exports.EvaluationSampleSchema = zod_1.z.object({
    testCaseId: zod_1.z.string().optional(),
    input: zod_1.z.any(),
    output: zod_1.z.any(),
    error: zod_1.z.string().optional(),
    context: zod_1.z.array(zod_1.z.any()).optional(),
    reference: zod_1.z.any().optional(),
    traceIds: zod_1.z.array(zod_1.z.string()).optional(),
});
exports.EvaluationDatasetSchema = zod_1.z.array(exports.EvaluationSampleSchema);
exports.EvalInputSchema = zod_1.z.object({
    testCaseId: zod_1.z.string(),
    input: zod_1.z.any(),
    output: zod_1.z.any(),
    error: zod_1.z.string().optional(),
    context: zod_1.z.array(zod_1.z.any()).optional(),
    reference: zod_1.z.any().optional(),
    traceIds: zod_1.z.array(zod_1.z.string()),
});
exports.EvalInputDatasetSchema = zod_1.z.array(exports.EvalInputSchema);
const EvalStatusEnumSchema = zod_1.z.enum(['UNKNOWN', 'PASS', 'FAIL']);
var EvalStatusEnum;
(function (EvalStatusEnum) {
    EvalStatusEnum["UNKNOWN"] = "UNKNOWN";
    EvalStatusEnum["PASS"] = "PASS";
    EvalStatusEnum["FAIL"] = "FAIL";
})(EvalStatusEnum || (exports.EvalStatusEnum = EvalStatusEnum = {}));
exports.EvalMetricSchema = zod_1.z.object({
    evaluator: zod_1.z.string(),
    scoreId: zod_1.z.string().optional(),
    score: zod_1.z.union([zod_1.z.number(), zod_1.z.string(), zod_1.z.boolean()]).optional(),
    status: EvalStatusEnumSchema.optional(),
    rationale: zod_1.z.string().optional(),
    error: zod_1.z.string().optional(),
    traceId: zod_1.z.string().optional(),
    spanId: zod_1.z.string().optional(),
});
exports.EvalResultSchema = exports.EvalInputSchema.extend({
    metrics: zod_1.z.array(exports.EvalMetricSchema).optional(),
});
exports.EvalRunKeySchema = zod_1.z.object({
    actionRef: zod_1.z.string().optional(),
    datasetId: zod_1.z.string().optional(),
    datasetVersion: zod_1.z.number().optional(),
    evalRunId: zod_1.z.string(),
    createdAt: zod_1.z.string(),
    actionConfig: zod_1.z.any().optional(),
    metricSummaries: zod_1.z.array(zod_1.z.record(zod_1.z.string(), zod_1.z.any())).optional(),
});
exports.EvalKeyAugmentsSchema = exports.EvalRunKeySchema.pick({
    datasetId: true,
    datasetVersion: true,
    actionRef: true,
    actionConfig: true,
});
exports.EvalRunSchema = zod_1.z.object({
    key: exports.EvalRunKeySchema,
    results: zod_1.z.array(exports.EvalResultSchema),
    metricsMetadata: zod_1.z
        .record(zod_1.z.string(), zod_1.z.object({
        displayName: zod_1.z.string(),
        definition: zod_1.z.string(),
    }))
        .optional(),
});
exports.DatasetSchemaSchema = zod_1.z.object({
    inputSchema: zod_1.z
        .record(zod_1.z.any())
        .describe('Valid JSON Schema for the `input` field of dataset entry.')
        .optional(),
    referenceSchema: zod_1.z
        .record(zod_1.z.any())
        .describe('Valid JSON Schema for the `reference` field of dataset entry.')
        .optional(),
});
exports.DatasetTypeSchema = zod_1.z.enum(['UNKNOWN', 'FLOW', 'MODEL']);
exports.DatasetMetadataSchema = zod_1.z.object({
    datasetId: zod_1.z.string(),
    size: zod_1.z.number(),
    schema: exports.DatasetSchemaSchema.optional(),
    datasetType: exports.DatasetTypeSchema,
    targetAction: zod_1.z.string().optional(),
    metricRefs: zod_1.z.array(zod_1.z.string()).default([]),
    version: zod_1.z.number(),
    createTime: zod_1.z.string(),
    updateTime: zod_1.z.string(),
});
//# sourceMappingURL=eval.js.map