/**
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
type PredictMethod = 'predict' | 'predictLongRunning';
interface Operation {
    name: string;
    done?: boolean;
    error?: {
        message: string;
    };
    response?: {
        generateVideoResponse: {
            generatedSamples: {
                video: {
                    uri: string;
                };
            }[];
        };
    };
}
type PredictClient<I = unknown, R = unknown, P = unknown> = (instances: I[], parameters: P) => Promise<R>;
declare function predictModel<I = unknown, R = unknown, P = unknown>(model: string, apiKey: string, method: PredictMethod): PredictClient<I, R, P>;
declare function checkOp(operation: string, apiKey: string): Promise<Operation>;

export { type Operation, type PredictClient, type PredictMethod, checkOp, predictModel };
